unit AirCraft01;

interface

uses Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
     Dialogs, ExtCtrls,
     UserApp03Data;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
type TAirCraft = class(TObject)
private
   // -----------------
   //  
   fId     : string;     //  
   fFName  : string;     //      
   fLenX   : extended;   //    (.)
   fLenY   : extended;   //    (.)
   fWeight : extended;   //   
   fRectLZ : TRect;      // Rect    
   // -----------------
   //  
   fScaleX   : extended;   //      
   fScaleY   : extended;   //      
   // -----------------
   //        
   function CalcScale() : boolean;
public
   // ------------------------------------------
   constructor Create(RqAirCraftRec : TAirCraftRec);
   // ------------------------------------------
   //      Image
   procedure ShowLoadingZone(RqImg : TImage);
   //  Rect     
   function XYLenToRect (RqXB,RqYB : integer;
                         RqLenX,RqLenY : extended) : TRect;
   // Y -  RqRect   
   function YOfsetRect(RqRect : TRect) : extended;
   // X -  RqRect   
   function XOfsetRect(RqRect : TRect) : extended;
   // ------------------------------------------
   property Id        : string    read fId;
   property FName     : string    read fFName;
   property LenX      : extended  read fLenX;
   property LenY      : extended  read fLenY;
   property Weight    : extended  read fWeight;
   property RectLZ    : TRect     read fRectLZ;
   property ScaleX    : extended  read fScaleX;
   property ScaleY    : extended  read fScaleY;
end;

// ========================================================================
// ========================================================================

implementation

// ========================================================================
// ========================================================================
// ------------------------------------------------------------------------
//        
function TAirCraft.CalcScale() : boolean;
begin
    Result := False;
    //  
    fScaleX  := 0;
    fScaleY  := 0;
    if (fLenX < 1) or (fLenY < 1)
    then Exit;
    if ((fRectLZ.Right -  fRectLZ.Left) < 1) or
       ((fRectLZ.Bottom - fRectLZ.Top)  < 1)
    then Exit;
    //  
    try
       fScaleX := (fRectLZ.Right  - fRectLZ.Left) / fLenX;
       fScaleY := (fRectLZ.Bottom - fRectLZ.Top)  / fLenY;
       Result := True;
    except
       fScaleX  := 0;
       fScaleY  := 0;
    end;
end;

// ------------------------------------------------------------------------
// X -  RqRect   
function TAirCraft.XOfsetRect(RqRect : TRect) : extended;
begin
    if fScaleX > 0
    then Result := (RqRect.Left - fRectLZ.Left) / fScaleX
    else Result := 0;
end;

// ------------------------------------------------------------------------
// Y -  RqRect   
function TAirCraft.YOfsetRect(RqRect : TRect) : extended;
begin
    if fScaleY > 0
    then Result := (RqRect.Top - fRectLZ.Top) / fScaleY
    else Result := 0;
end;

// ------------------------------------------------------------------------
constructor TAirCraft.Create(RqAirCraftRec : TAirCraftRec);
begin
    inherited Create;
    with RqAirCraftRec do
    begin
      fId      := Id;
      fFName   := FName;
      fLenX    := LenX;
      fLenY    := LenY;
      fWeight  := Weight;
      fRectLZ  := RectLZ;
    end;
    CalcScale();
end;
// ------------------------------------------------------------------------
//      Image
procedure TAirCraft.ShowLoadingZone(RqImg : TImage);
var wX, wY : integer;
begin
    with RqImg.Canvas do
    begin
       // ------------------------------------------
       //    
       Pen.Color := clGreen;
       Pen.Width := 2;
       Brush.Style := bsClear;
       Rectangle(fRectLZ);
(*      //  
       //       
       Ellipse(fRectLZ.Left - 3, fRectLZ.Top - 3,
               fRectLZ.Left + 3, fRectLZ.Top + 3 );
       TextOut(fRectLZ.Left + 8, fRectLZ.Top + 4, 'X0,Y0 -  ');
*)
       // ------------------------------------------
       //      
       //       
       Pen.Color := clBlue;
       Pen.Width := 1;
       Pen.Style := psDash;
       wY := fRectLZ.Top + Round(fScaleY * fLenY / 2);
       MoveTo(fRectLZ.Left,  wY);
       LineTo(fRectLZ.Right, wY);
       wX := fRectLZ.Left + Round(fScaleX * fLenX / 2);
       MoveTo(wX, fRectLZ.Top);
       LineTo(wX, fRectLZ.Bottom);
       Pen.Style := psSolid;
(*      //  
       TextOut(wX + 8, wY + 4, 'X0,Y0 -    ');
*)
    end;
end;
// ------------------------------------------------------------------------
//  Rect     
function TAirCraft.XYLenToRect (RqXB,RqYB : integer;
                                RqLenX,RqLenY : extended) : TRect;
var wXL, wYL : integer;
begin
    // X -   
    if fScaleX > 0
    then wXL := Round(fScaleX * RqLenX)
    else wXL := 2;
    // Y -   
    if fScaleY > 0
    then wYL := Round(fScaleY * RqLenY)
    else wYL := 2;
    // ------------------------------
    Result := Rect(RqXB,RqYB, RqXB + wXL,RqYB + wYL);
end;

// ------------------------------------------------------------------------
// ========================================================================
//      
// ========================================================================
end.
